/*
 * Decompiled with CFR 0.152.
 */
package ibm.nways.lspeed;

import ibm.nways.jdm.eui.PropertySection;
import ibm.nways.lspeed.LsViewSelectionChoiceWidget;
import ibm.nways.lspeed.LsViewSelectionHandler;
import ibm.nways.lspeed.LsViewSelectionListWidget;
import ibm.nways.lspeed.LsViewSelectionWidget;
import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;

public class LsViewSelectionSection
extends PropertySection
implements ItemListener {
    private LsViewSelectionWidget selectionWidget;
    private int widgetType;
    private LsViewSelectionHandler handler;
    private int currentIndex;

    public LsViewSelectionSection(LsViewSelectionHandler lsViewSelectionHandler) {
        this(lsViewSelectionHandler, 1);
    }

    public LsViewSelectionSection(LsViewSelectionHandler lsViewSelectionHandler, int n) {
        this.handler = lsViewSelectionHandler;
        this.widgetType = n;
        this.setLayout(new GridBagLayout());
        this.setInsets(new Insets(5, 5, 5, 5));
    }

    public void layoutSection() {
        this.selectionWidget = this.widgetType == 2 ? new LsViewSelectionListWidget() : new LsViewSelectionChoiceWidget();
        this.selectionWidget.addItemListener(this);
        this.handler.addViews(this.selectionWidget);
        this.selectionWidget.selectView(this.handler.getSelectedView());
        this.currentIndex = this.selectionWidget.getSelectedIndex();
        this.addRow(this.handler.getViewSelectionName(), (Component)((Object)this.selectionWidget));
    }

    public void apply() {
    }

    public void reset() {
        this.selectionWidget.selectView(this.handler.getSelectedView());
        this.currentIndex = this.selectionWidget.getSelectedIndex();
        this.doLayout();
    }

    protected void rowChange() {
        this.doLayout();
    }

    public boolean validateSection() {
        return true;
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        System.out.println("View Selected");
        int n = this.selectionWidget.getSelectedIndex();
        if (n != this.currentIndex) {
            this.currentIndex = n;
            this.handler.setSelectedView(this.selectionWidget.getKeyForIndex(this.currentIndex));
        }
    }

    public static class WidgetType {
        public static final int CHOICE = 1;
        public static final int LIST = 2;
    }
}

